extends Area2D

@export var speed = 1000
var velocity = Vector2.ZERO
var screen_size = Vector2.ZERO

# Called when the node enters the scene tree for the first time.
func start(_transform):
	screen_size = get_viewport_rect().size
	transform = _transform
	velocity = transform.x * speed


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	position += velocity * delta
	#var new_position = position
	#new_position.x = wrapf(position.x, 0, screen_size.x)
	#new_position.y = wrapf(position.y, 0, screen_size.y)
	#position = new_position


func _on_visible_on_screen_notifier_2d_screen_exited():
	queue_free()


func _on_body_entered(body):
	if body.is_in_group("rocks"):
		body.explosion()
		queue_free()
