extends Node

var screen_size = Vector2.ZERO

@export var rock_scene : PackedScene


# Called when the node enters the scene tree for the first time.
func _ready():
	screen_size = get_viewport().get_visible_rect().size
	
	for i in 5:
		spawn_rocks(3)

func spawn_rocks(size, position = null, velocity = null):
	if position == null:
		$RockPath/RockSpawn.progress = randi()
		position = $RockPath/RockSpawn.position
	if velocity == null:
		velocity = Vector2.RIGHT.rotated(randf_range(0, TAU)) * randf_range(20, 350)
	var r = rock_scene.instantiate()
	r.screen_size= screen_size
	r.start(position, velocity, size)
	call_deferred("add_child", r)
	
# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	pass
