extends RigidBody2D

var screen_size = Vector2.ZERO
var size
var radius
var rock_scale = 0.2
# Called when the node enters the scene tree for the first time.
func start(_position, _velocity, _size):
	position = _position
	size = _size
	mass = 2.3 * size
	$Sprite2D.scale = Vector2.ONE * rock_scale * size
	radius = int($Sprite2D.texture.get_size().x/2 * $Sprite2D.scale.x)
	var shape = CircleShape2D.new()
	shape.radius = radius
	$CollisionShape2D.shape = shape
	linear_velocity = _velocity
	angular_velocity = randf_range(0,2*PI)


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	pass
