extends CanvasLayer

signal startGame

func updateScore(value):
	$MarginContainer/Score.text = str(value)
	
func updateTime(value):
	$MarginContainer/Time.text = str(value)
# Called when the node enters the scene tree for the first time.
func _ready():
	pass # Replace with function body.


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	pass

func showMessage(text):
	$Message.text = text
	$Message.show()
	$Timer.start()

func _on_timer_timeout():
	$Message.hide()


func _on_button_pressed():
	$Button.hide()
	$Message.hide()
	startGame.emit()
	
func showGameOver():
	showMessage("Game Over!")
	await $Timer.timeout
	$Button.show()
	$Message.text = "Mask Dude Run"
	$Message.show()
